﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace AutomatGH
{
    public partial class Form1 : Form
    {
        Point p = Point.Empty;
        Graphics gfx;
        Bitmap test;
        Color brushColor = Color.White;
        string odblokuj = "Wyczyść dane";
        string zablokuj = "Załaduj dane";

        public Form1()
        {
            InitializeComponent();

            pictureBox1.BackColor = Color.White;
            int width = pictureBox1.Width;
            int height = pictureBox1.Height;
            pictureBox1.Image = new Bitmap(width, height);

            test = new Bitmap(width, height);
            gfx = Graphics.FromImage(test);
            //gfx = Graphics.FromImage(pictureBox1.Image);
            gfx.Clear(Color.White);

            bu_laduj.Text = zablokuj;
            ramka.Text = "Krok: 0/0";
        }
#region Class

        class Ustawienia
        {
            public static int max;
            public static int pix;
            public static int count;
            public static int sleep;
            public static int[, ,] table;

            public static int skok;

            public static string op0;
            public static string op1;
            public static string op2;
        }

#endregion
#region Funkcje

        public void PobieranieDanych(bool kolory, bool tablica, bool glowne=true)
        {
            if (glowne == true)
            {
                Ustawienia.pix = Int32.Parse(tb_px.Text.ToString());
                Ustawienia.max = pictureBox1.Width / Ustawienia.pix;
                Ustawienia.count = Int32.Parse(tb_max.Text.ToString());
                Ustawienia.sleep = Int32.Parse(tb_ms.Text.ToString());
                Ustawienia.skok = Int32.Parse(tb_krok.Text.ToString());
            }
            if (kolory == true)
            {
                Ustawienia.op0 = comboBox1.Text;
                Ustawienia.op1 = comboBox2.Text;
                Ustawienia.op2 = comboBox3.Text;
            }
            if (tablica == true)
            {
                Ustawienia.table = new int[Ustawienia.count, Ustawienia.max, Ustawienia.max];
            }
        }
        public void RysowaniePlanszy(int c, int pix, int max, int[,,] table)
        {
            string op0 = Ustawienia.op0;
            string op1 = Ustawienia.op1;
            string op2 = Ustawienia.op2;

            int tmp;

            for (int j = 0; j < max; j++)
                for (int i = 0; i < max; i++)
                {
                    tmp = table[c, i, j];
                    switch (tmp)
                    {
                        case 0: brushColor = Color.FromName(op0); break;
                        case 1: brushColor = Color.FromName(op1); break;
                        case 2: brushColor = Color.FromName(op2); break;
                        default: brushColor = Color.FromName(op0); break;
                    }
                    SolidBrush myBrush = new SolidBrush(brushColor);
                    gfx.FillRectangle(myBrush, i * pix, j * pix, pix, pix);
                }
        }
        public void Obliczenia()
        {
            int tmp;
            int[, ,] table = Ustawienia.table;
            int count = Ustawienia.count;
            int max = Ustawienia.max;
            int sleep = Ustawienia.sleep;
            int pix = Ustawienia.pix;

            try
            {
                for (int c = 0; c < count - 1; c++)
                {
                    for (int j = 0; j < max; j++)
                        for (int i = 0; i < max; i++)
                        {
                            tmp = table[c, i, j];
                            if (tmp == 2)
                                table[c + 1, i, j] = 0;
                            else if (tmp == 1)
                            {
                                table[c + 1, i, j] = 2;
                                for (int y = -1; y <= 1; y++)
                                    for (int x = -1; x <= 1; x++)
                                    {
                                        if (x != 0 && y != 0)   //Sąsiedztwo von Neumanna
                                            //if (x == 0 && y == 0) // Sąsiedztwo Moore'a
                                            continue;

                                        int xT = i + x;
                                        int yT = j + y;

                                        if (checkBox1.Checked == true)
                                        {
                                            // Oddziaływanie brzegowe
                                            if (xT >= max)
                                                xT = 0;
                                            else if (xT < 0)
                                                xT = max-1;

                                            if (yT >= max)
                                                yT = 0;
                                            else if (yT < 0)
                                                yT = max-1;
                                        }
                                        else
                                        {
                                            if (xT >= max || yT >= max || xT < 0 || yT < 0)
                                                continue;
                                        }

                                        if (table[c, xT, yT] == 0)
                                            table[c + 1, xT, yT] = 1;
                                    }
                            }
                        }
                    Ustawienia.table = table;
                }
            }
            catch(Exception ex)
		    {
			    //MessageBox.Show("Błedne dane");
                throw new Exception("Błedne dane");
		    }
        }

#endregion
#region Przyciski

        // Start/Stop
        private void button1_Click(object sender, EventArgs e)
        {
            if (backgroundWorker1.IsBusy != true)
            {
                bu_start.Text = "Stop";
                backgroundWorker1.WorkerReportsProgress = true;
                backgroundWorker1.WorkerSupportsCancellation = true;
                backgroundWorker1.RunWorkerAsync();
                groupBox4.Hide();
                bu_laduj.Hide();
                bu_losuj.Hide();
            }
            else if(backgroundWorker1.WorkerSupportsCancellation == true)
            {
                bu_start.Text = "Start";
                backgroundWorker1.CancelAsync();
                groupBox4.Show();
                bu_laduj.Show();
                bu_losuj.Show();
            }
        }
        // Losuj układ
        private void button3_Click(object sender, EventArgs e)
        {
            PobieranieDanych(true, true);
            textBox4.Text = (Ustawienia.max * Ustawienia.max).ToString();

            Random random = new Random();
            int tmp;

            for (int j = 0; j < Ustawienia.max; j++)
                for (int i = 0; i < Ustawienia.max; i++)
                {
                    tmp = random.Next(1000);
                    tmp %= 7;
                    Ustawienia.table[0, i, j] = tmp;
                }

            RysowaniePlanszy(0, Ustawienia.pix, Ustawienia.max, Ustawienia.table);
            textBox5.Text = ((double)Ustawienia.table.Length * (double)sizeof(int) / (1000 * 1000)).ToString("#,##0.00");
            
            bar_progres.Maximum = Ustawienia.count - 1;
            tb_max.ReadOnly = true;
            tb_px.ReadOnly = true;
            tb_ms.ReadOnly = true;
            tb_krok.ReadOnly = true;
            checkBox1.Enabled = false;
            groupBox4.Show();
            bu_start.Show();
            bu_laduj.Text = odblokuj;

            pictureBox1.Refresh();
        }
        // Zablokuj/Odblokuj
        private void button2_Click(object sender, EventArgs e)
        {
            if (bu_laduj.Text == zablokuj)
            {
                PobieranieDanych(true, true);

                RysowaniePlanszy(0, Ustawienia.pix, Ustawienia.max, Ustawienia.table);
                pictureBox1.Refresh();

                textBox4.Text = (Ustawienia.max * Ustawienia.max).ToString();
                textBox5.Text = ((double)Ustawienia.table.Length * (double)sizeof(int) / (1000 * 1000)).ToString("#,##0.00");
                bar_progres.Maximum = Ustawienia.count - 1;

                tb_max.ReadOnly = true;
                tb_px.ReadOnly = true;
                tb_ms.ReadOnly = true;
                tb_krok.ReadOnly = true;
                checkBox1.Enabled = false;
                groupBox4.Show();
                bu_start.Show();
                bu_laduj.Text = odblokuj;
            }
            else if (bu_laduj.Text == odblokuj)
            {
                Ustawienia.table = new int[1, Ustawienia.max, Ustawienia.max];
                Array.Clear(Ustawienia.table, 0, Ustawienia.table.Length);
                textBox5.Text = ((double)Ustawienia.table.Length * (double)sizeof(int) / (1000 * 1000)).ToString("#,##0.00");

                gfx.Clear(Color.FromName(comboBox1.Text));
                pictureBox1.Refresh();

                textBox4.Text = "";
                tb_max.ReadOnly = false;
                tb_px.ReadOnly = false;
                tb_ms.ReadOnly = false;
                tb_krok.ReadOnly = false;
                checkBox1.Enabled = true;
                trackBar1.Minimum = 1;
                trackBar1.Maximum = 1;
                bu_start.Hide();
                groupBox4.Hide();
                bu_laduj.Text = zablokuj;

                bar_progres.Value = 0;
            }
        }

#endregion      
#region BackgroundWorker

        // Background rysowanie
        private void backgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            PobieranieDanych(false, false);

            Thread trd = new Thread(new ThreadStart(Obliczenia));
            trd.IsBackground = true;
            trd.Start();

            int[, ,] table = Ustawienia.table;
            int count = Ustawienia.count;
            int max = Ustawienia.max;
            int sleep = Ustawienia.sleep;
            int pix = Ustawienia.pix;
            int skok = Ustawienia.skok;

            if (skok == 0 || skok >= max)
                skok = 1;

            BackgroundWorker worker = sender as BackgroundWorker;

            double r = (double)(100/count);

            for (int c = 0; c < count; c+=skok)
            {
                if (backgroundWorker1.CancellationPending == true)
                {
                    e.Cancel = true;
                    break;
                }                
                RysowaniePlanszy(c, pix, max, table);
                backgroundWorker1.ReportProgress(c);
                Thread.Sleep(sleep);
            }  
        }
        // Zmiana procesu
        private void backgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            try
            {
                bar_progres.Value = e.ProgressPercentage;
                ramka.Text = "Krok: " + e.ProgressPercentage.ToString();
                pictureBox1.Image = test;
                pictureBox1.Refresh();
            }
            catch
            {
                MessageBox.Show("Nieznany błąd", "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        // Po wykonaniu backgroundu
        private void backgroundWorker1_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                MessageBox.Show("Wystąpił błąd podczas wykonywania: ", e.Error.Message);
            }
            else
            {
                trackBar1.Minimum = 0;
                trackBar1.Maximum = Ustawienia.count - 1;
                trackBar1.Value = trackBar1.Maximum;
                //bar_progres.Value = bar_progres.Maximum;
                bu_losuj.Show();
                bu_laduj.Show();
                bu_start.Text = "Start";
                ramka.Text = "Krok: " + (trackBar1.Value + 1).ToString() + "/" + (trackBar1.Maximum + 1).ToString();
            }
        }

#endregion
#region Pozostałe

        // rysowanie pkt myszka
        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            if (bu_laduj.Text == odblokuj)
            {
                int op = -1;
                if (radioButton1.Checked == true)
                {
                    brushColor = Color.FromName(comboBox1.Text);
                    op = 0;
                }
                else if (radioButton2.Checked == true)
                {
                    brushColor = Color.FromName(comboBox2.Text);
                    op = 1;
                }
                else if (radioButton3.Checked == true)
                {
                    brushColor = Color.FromName(comboBox3.Text);
                    op = 2;
                }

                int pix = Int32.Parse(tb_px.Text.ToString());
                if (e.Button == MouseButtons.Left)
                {
                    p = e.Location;
                    SolidBrush myBrush = new SolidBrush(brushColor);
                    gfx.FillRectangle(myBrush, p.X, p.Y, pix, pix);
                    Ustawienia.table[0, p.X / Ustawienia.pix, p.Y / Ustawienia.pix] = op;
                }
                pictureBox1.Refresh();
            }
        }
        // skrol korkow
        private void trackBar1_Scroll(object sender, EventArgs e)
        {
            PobieranieDanych(true, false, false);
            int c = trackBar1.Value;
            RysowaniePlanszy(c, Ustawienia.pix, Ustawienia.max, Ustawienia.table);
            pictureBox1.Refresh();
            ramka.Text = "Krok: " + (c + 1).ToString() + "/" + (trackBar1.Maximum + 1).ToString();
        }
        // Podczas wylaczania formy, sprawdz czy background dziala, jesli tak, to go wylacz
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (backgroundWorker1.IsBusy == true)
                backgroundWorker1.CancelAsync();
        }
        
#endregion
#region Menu


        private void zapiszObrazekToolStripMenuItem_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();
            saveFileDialog1.Filter = "JPEG|*.jpg|Mapa bitowa|*.bmp|GIF|*.gif";
            saveFileDialog1.Title = "Save an Image File";
            saveFileDialog1.ShowDialog();
            if (saveFileDialog1.FileName != "")
            {
                pictureBox1.Image.Save(saveFileDialog1.FileName);
            }
        }

        private void załadujUkładToolStripMenuItem_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();
            openFileDialog1.Title = "Wybierz układ do wczytania";
            openFileDialog1.InitialDirectory = @".";
            openFileDialog1.Filter = "JPEG|*.jpg|Mapa bitowa|*.bmp|GIF|*.gif";
            openFileDialog1.FilterIndex = 2;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                Bitmap img = new Bitmap(openFileDialog1.FileName);
                PobieranieDanych(true, true, true);

                for (int i = 0; i < img.Width; i++)
                    for (int j = 0; j < img.Height; j++)
                    {
                        if (i >= Ustawienia.max || j >= Ustawienia.max)
                            break;
                        Color originalColor = img.GetPixel(i, j);
                        int grayScale = (int)((originalColor.R * .3) + (originalColor.G * .59)
                            + (originalColor.B * .11));
                        Color newColor = Color.FromArgb(grayScale, grayScale, grayScale);
                        img.SetPixel(i, j, newColor);
                    }
                pictureBox1.Image = img;
                gfx = Graphics.FromImage(pictureBox1.Image);
            }
        }

        private void oProgramieToolStripMenuItem_Click(object sender, EventArgs e)
        {
            new Form2().Show();
        }

        private void zasadaDziałaniaToolStripMenuItem_Click_1(object sender, EventArgs e)
        {
            new Form2().Show();
        }

#endregion
    }
}
